<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Courriel;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;
use lib\Navigation;

use entities\Randonnee;
use entities\Parcour;
use entities\Programme;
use entities\Reconnaissance;
use entities\Membre;
use entities\Reco_Participant;
use entities\Reco_Synthese;

class ReconnaissanceController extends EntityController
{
	public static $SECURITY          = array(
		'list'           => array(2,5),
		'display'        => array(2,5), 
		'insert'         => array(2,5), 
		'update'         => array(0,5),
		'delete'         => array(0,5),
		'valide'         => array(5),
		'cancel'         => array(5),
		'synthese'       => array(0,5),
		'frais'          => array(0,5),
		);

	protected static $ENTITY            = "entities\Reconnaissance";
	protected static $PATH_VIEW_LIST    = 'views/reconnaissance/list.php';
	protected static $PATH_VIEW_DISPLAY = 'views/reconnaissance/display.php';
	protected static $PATH_VIEW_INSERT  = 'views/reconnaissance/insert.php';
	protected static $PATH_VIEW_UPDATE  = 'views/reconnaissance/insert.php';
	protected static $PATH_VIEW_PARTICIPANTS_LIST = 'views/reco_participant/list.php';

	public function listAction($params=null)
	{
		$Model['titre_page']    = "Liste des reconnaissances programmées";
		$Model['datedebut'] = '01/'.date('m/Y');
		$entity = static::$ENTITY;
		$filtre = "";
		$sort   = "datereco ASC";
		
		if ( isset($_POST['validForm']) ) {
			if ( !empty($_POST['datedebut']) ) $Model['datedebut'] = $_POST['datedebut'];
			if ( !empty($_POST['datefin']) )   $Model['datefin']   = $_POST['datefin'];
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
		}
		elseif ( $filtres = Navigation::callFiltre() ) {
			$Model = $filtres;
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
		}
		$filtre .= $this->createFiltre( $Model );

		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['lstEntities']   = $entity::selectList($filtre,$sort);
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}


	private function createFiltre( $Model ) 
	{
		$filtre = "";
		if ( !empty($Model['datedebut']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "datereco >= STR_TO_DATE('".DBConnexion::SQLEncode($Model['datedebut'])."','%d/%m/%Y')";
		}
		if ( !empty($Model['datefin']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "datereco < STR_TO_DATE('".DBConnexion::SQLEncode($Model['datefin'])." 23:59','%d/%m/%Y') + INTERVAL 1 DAY";
		}
		return $filtre;
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$reco = new Reconnaissance($_POST);
			$reco->id_createur = Security::getConnectedUser()->id;
			// Ajouter Liste des Rôles
			$reco->insert(true);
			Courriel::newPrevisionMail($reco,'reco');
			throw new GoPrevException('MSG-QUERYINSERT');
		}
		
		// Affichage du formulaire
		$reco = new Reconnaissance();
		$reco->id_responsable = Security::getConnectedUser()->id;
		if ( isset($_GET['id_programme']) || isset($_POST['id_programme']) ) {
			$reco->id_programme = intval( (isset($_GET['id_programme'])) ? $_GET['id_programme'] : $_POST['id_programme'] );
		}
		$Model['titre_page']     = "Nouvelle reconnaissance";
		$Model['corps_page']     = static::$PATH_VIEW_INSERT;
		$Model['entity']         = $reco;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$reco = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$reco->setAttributes($_POST);
			$reco->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		
		// Affichage du formulaire
		$Model['titre_page']    = "Modification d'une reconnaissance";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $reco;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function syntheseAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$reco = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$synthese = new Reco_Synthese();
			$synthese->id_createur = Security::getConnectedUser()->id;
			$synthese->id_reconnaissance = $reco->id;
			$synthese->remarques = $_POST['remarques'];
			$synthese->insert(true);
			Courriel::newPrevisionMail($reco,'synthese_reco');
			throw new GoPrevException('MSG-QUERYINSERT');
		}
		
		// Affichage du formulaire
		$Model['titre_page']    = "Synthese d'une reconnaissance";
		$Model['corps_page']    = 'views/synthese/syntheseReco.php';
		$Model['entity']        = $reco;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function fraisAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$reco = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$synthese = $reco->synthese;
			if ( !empty($_POST['remboursement']) ) $synthese->remboursement = 1;
			for ( $cpt = 1; $cpt <= $reco->vehicule; $cpt++) {
				$col = 'vehicule'.$cpt;
				if ( !empty($_POST['vehicule'.$cpt]) ) $synthese->$col = 1;
				else $synthese->$col = 0;
			}
			if ( $reco->vehiculeFormation > 0 && !empty($_POST['vehiculeFormation']) ) $synthese->vehiculeFormation = 1;
			else $synthese->vehiculeFormation = 0;
			$synthese->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		
		// Affichage du formulaire
		$Model['titre_page']    = "Synthese d'une reconnaissance";
		$Model['corps_page']    = 'views/synthese/fraisReco.php';
		$Model['entity']        = $reco;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function valideAction($params=null)
	{
		// Affichage du formulaire
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$entity = $params['entity'];
		$entity->etat = 1;
		$entity->update(true);
		throw new Exception();
	}

	public function listParticipantsAction($params=null)
	{
		if ( empty($_GET['idReco']) ) throw new Exception('ERR-NOID');
		$Model['entity']        = new Reconnaissance(intval($_GET['idReco']));
		$Model['titre_page']    = "Gestion des participants à ne reconnaisance";
		$Model['corps_page']    = static::$PATH_VIEW_PARTICIPANTS_LIST;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function addParticipantAction($params=null)
	{
		if ( empty($_GET['valEntity']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'nomparticipant' ));
		$participant = new Reco_Participant();
		$filtre  = "'".$_GET['valEntity']."' LIKE CONCAT(nom,' ',prenom)";
		$lst = Membre::selectList($filtre);
		if ( count($lst) == 1 ) $participant->id_participant = current($lst);
		else throw new Exception('MSG-PERSONNEINTROUVABLE');
		$Model['pos']           = intval($_GET['pos']);
		$Model['boutons']       = true;
		$Model['titre_page']    = "Ajouter un participant à la reconnaissance";
		$Model['corps_page']    = 'views/reco_participant/displayCell.php';
		$Model['entityRel']     = $participant;
		return array($Model['corps_page'],$Model,true);
	}

	public function deleteParticipantAction($params=null)
	{
		if ( ! isset($_GET['id_reconnaissance']) ) throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'id_reconnaissance') );
		if ( ! isset($_GET['id_participant']) )    throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'id_participant') );
		$participant = new Reco_Participant( intval($_GET['id_reconnaissance']) , intval($_GET['id_participant']) );
		$participant->delete();
		throw new Exception('MSG-QUERYDELETE');
	}

}