<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\security\Security;
use lib\Navigation;

use entities\Randonnee;
use entities\Parcour;
use entities\TypeRando;
use entities\Programme;

class RandonneeController extends EntityController
{
	public static $SECURITY = array(
		'list'           => array(2,5),
		'display'        => array(5), 
		'insert'         => array(2,5), 
		'update'         => array(7),
		'delete'         => array(7),
		'add'            => array(2,5),
		);
		
	protected static $ENTITY            = "entities\Randonnee";
	protected static $PATH_VIEW_LIST    = 'views/randonnee/list.php';
	protected static $PATH_VIEW_DISPLAY = 'views/randonnee/display.php';
	protected static $PATH_VIEW_INSERT  = 'views/randonnee/insert.php';
	protected static $PATH_VIEW_ADD     = 'views/randonnee/add.php';
	protected static $PATH_VIEW_UPDATE  = 'views/randonnee/insert.php';
	protected static $PATH_VIEW_DELETE  = 'views/randonnee/delete.php';

	public function listAction($params=null)
	{
		$Model['titre_page']    = "Liste des lieux de randonnées";
		$entity = static::$ENTITY;
		$filtre = "";
		$sort   = "departement,commune,lieu";
		if ( isset($_POST['validForm']) ) {
			if ( !empty($_POST['departement']) ) $Model['departement'] = $_POST['departement'];
			if ( !empty($_POST['recherche']) )   $Model['recherche']   = $_POST['recherche'];
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		elseif ( $filtres = Navigation::callFiltre() ) {
			$Model = $filtres;
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['lstEntities']   = $entity::selectList($filtre,$sort);
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	private function createFiltre( $Model ) 
	{
		$filtre = "";
		if ( !empty($Model['departement']) ) {
			$departement = $Model['departement'];
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "departement LIKE '%$departement%'";
		}
		if ( !empty($Model['recherche']) ) {
			$recherche = $Model['recherche'];
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "( commune LIKE '%$recherche%' OR lieu LIKE '%$recherche%' )";
		}
		return $filtre;
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$rando = new Randonnee($_POST);
			$rando->id_createur = Security::getConnectedUser()->id;
			$rando->insert(true);
			header('Location: _Programme_insert&id_randonnee='.$rando->id);
			exit;
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Nouveau site de randonnée";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = new Randonnee();
		return array(static::$PATH_VIEW_LAYOUT,$Model,true);
	}

	public function addAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$rando = new Randonnee($_POST);
			$rando->id_createur = Security::getConnectedUser()->id;
			$rando->insert(true);
			$programme = new Programme();
			$programme->id_randonnee = $rando;
			Navigation::putFiltre($programme,"_Programme_insert");
			throw new Exception();
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Nouveau site de randonnée";
		$Model['corps_page']    = static::$PATH_VIEW_ADD;
		$Model['entity']        = new Randonnee();
		return array(static::$PATH_VIEW_ADD,$Model,true);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$entity = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity->setAttributes($_POST);
			$entity->update(true);
			throw new Exception('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		if ( empty($_GET['id']) ) throw new Exception('ERR-NOID');
		$Model['titre_page']    = "Modification du site de randonnée";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
}