<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\Constantes;
use entities\Information;
use entities\Programme;
use entities\Phrase;

class PhraseController extends EntityController
{
	public static $SECURITY = array(
		'edit'       => array(5),
		);

	protected static $PATH_VIEW_INSERT    = 'views/phrase/insert.php';
	protected static $PATH_VIEW_UPDATE    = 'views/phrase/insert.php';
	
	public function editAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			$phrase = new Phrase($_POST);
			if ( $phrase->id == null ) $phrase->insert();
			else $phrase->update();
			throw new Exception('MSG-QUERYUPDATE');
		}
		if ( empty($_GET['date']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'mois_annee' ));
		$Model['titre_page']    = "Edition de la phrase du mois";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$phrase = Phrase::selectList("mois_annee = STR_TO_DATE('".$_GET['date']."','%d/%m/%Y')","mois_annee ASC");
		if ( empty($phrase) ) {
			$phrase = new Phrase();
			$phrase->mois_annee = $_GET['date'];
		}
		else $phrase = current($phrase);
		$Model['entity']        = $phrase;
		return array($Model['corps_page'],$Model,true);
	}

}
