<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;

use entities\Programme;
use entities\Randonnee;
use entities\Parcour;
use entities\TypeRando;
use entities\Parcour_Fichier;
use entities\Programme_Parcour;

class ParcourController extends EntityController
{
	public static $SECURITY = array(
		'list'           => array(2,5),
		'display'        => array(5), 
		'insert'         => array(2,5), 
		'update'         => array(5,7),
		'delete'         => array(7),
		'add'            => array(2,5), 
		);
		
	protected static $ENTITY            = "entities\Parcour";
//	protected static $PATH_VIEW_LIST    = 'views/parcour/list.php';
	protected static $PATH_VIEW_INSERT  = 'views/parcour/insert.php';
	protected static $PATH_VIEW_UPDATE  = 'views/parcour/insert.php';
	protected static $PATH_VIEW_DISPLAY = 'views/parcour/display.php';

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$parcour = new Parcour($_POST);
			$parcour->id_createur = Security::getConnectedUser()->id;
			$parcour->insert(true);
			throw new GoPrevException('MSG-QUERYINSERT');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Nouveau parcours";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$parcour = new Parcour();
		if ( isset($_GET['idRando']) ) $parcour->id_randonnee = intval($_GET['idRando']);
		$Model['entity']     = $parcour;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}	

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$parcour = $params['entity'];
		//if ( Security::isCoordinateur() && !Security::isAdmin() && $parcour->nbPrograms > 0 ) throw new Exception('ERR-USER-NOTHABILIT');
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$parcour->setAttributes($_POST);
			$parcour->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Modification du parcours.";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $parcour;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception ( 'ERR-PARAM-NOID' );
		$entity = $params['entity'];
		if ( Security::isCoordinateur() && !Security::isAdmin() && $entity->nbPrograms > 0 ) throw new Exception('ERR-USER-NOTHABILIT');
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$entity->delete(true);
			throw new GoPrevException('MSG-QUERYDELETE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Suppression d'un élément";
		$Model['corps_page']    = static::$PATH_VIEW_DELETE;
		$Model['entity']        = $entity;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function addAction($params=null)
	{
		// Affichage du formulaire
		if ( isset($_POST['validForm']) ) {
			$parcour = new Parcour($_POST);
			if ( $parcour->id == null ) $parcour->insert();
			$entity = new Programme_Parcour();
			$entity->id_parcour = $parcour; 
			$Model['titre_page']    = "Associer un parcours";
			$Model['corps_page']    = 'views/parcour/displayElmt.php';
			$Model['entity']   = $entity;
			$Model['pos']      = $_POST['pos'];
			$Model['boutons']  = true;
			$Model['edit']     = true;
			$Model['idParent'] = $_GET['idProgramme'];
			return array('views/parcour/displayElmt.php',$Model,true);
		}
		$Model['titre_page']    = "Associer un parcours";
		$Model['corps_page']    = 'views/parcour/add.php';
		$Model['pos']           = ( isset($_GET['pos']) )  ? intval($_GET['pos'])  : 1;
		$Model['idc']           = ( isset($_GET['idc']) ) ? $_GET['idc'] : "#parcours";
		$Model['entityRel']     = new Randonnee( intval($_GET['idRando']) );
		$Model['ventile']       = $_GET['idProgramme'];
		if ( isset($_GET['idEntity']) ) {
			$Model['entity']    = new Parcour( intval($_GET['idEntity']) );
		}
		else {
			$Model['entity']    = new Parcour();
		}
		return array('views/parcour/add.php',$Model,true);
	}	

}