<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Courriel;
use lib\Navigation;
use lib\Constantes;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;

use entities\Membre;
use entities\Personne;
use entities\Participant;
use entities\Cheque;
use entities\Membre_Fichier;

class MembreController extends EntityController
{
	public static $SECURITY = array(
		'list'           => array(2,3,4,5,6,8),
		'display'        => array(0,2,3,4,5,6,8), 
		'insert'         => array(6), 
		'update'         => array(6),
		'delete'         => array(6),
		'changePwd'      => array(0,6),
		'archive'        => array(6),
		'changmtExercice'=> array(6),
		);

	protected static $ENTITY            = "entities\Membre";
	protected static $PATH_VIEW_LIST    = 'views/membre/list.php';
	protected static $PATH_VIEW_INSERT  = 'views/membre/insert.php';
	protected static $PATH_VIEW_UPDATE  = 'views/membre/insert.php';
//	protected static $PATH_VIEW_DELETE  = 'views/membre/delete.php';
	protected static $PATH_VIEW_DISPLAY = 'views/membre/display.php';

	public function listAction($params=null)
	{
		$Model['onglet'] = ( !empty($_GET['onglet']) ) ? $_GET['onglet'] : 'adherents';
		if ( Security::isAdmin() ) $filtre = '';
		else $filtre = "id != 1";
		if ( isset($_POST['validForm']) ) {
			$Model['id_etat']      = ( !empty($_POST['id_etat']) ) ? intval($_POST['id_etat']) : null;
			$Model['id_role']      = ( !empty($_POST['id_role']) ) ? intval($_POST['id_role']) : null;
			$Model['recherche']    = ( !empty($_POST['recherche']) ) ? $_POST['recherche'] : null;
			$Model['actif']        = ( !empty($_POST['actif']) ) ? intval($_POST['actif']) : null;
			$Model['datecreation'] = ( !empty($_POST['datecreation']) ) ? DBConnexion::SQLEncode($_POST['datecreation']) : null;
			if ( $Model['onglet'] == 'archives' ) $Model['id_etat'] = 7;
			if ( $Model['id_etat'] == 7 ) $Model['onglet'] = 'archives';

			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		elseif ( $filtres = Navigation::callFiltre() ) {
			$Model = $filtres;
			Navigation::putFiltre($Model); 
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= $this->createFiltre( $Model );
		}
		else {
			if ( !empty($filtre) ) $filtre .= " AND ";
			if ( $Model['onglet'] == 'archives' ) {
				$Model['id_role'] = null;
				$Model['id_etat'] = 7;
			}
			else {
				$Model['id_role'] = 1;
			}
			$filtre .= $this->createFiltre( $Model );
		}
		$ordre = 'nom,prenom,nomjeunefille';
		$Model['titre_page']    = "Liste des adhérents";
		$Model['corps_page']    = static::$PATH_VIEW_LIST;
		$Model['lstEntities']   = Membre::selectList($filtre,$ordre);
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	private function createFiltre( $Model ) 
	{
		$filtre = "";
		if ( !empty($Model['id_etat']) ) {
			$filtre .= "id_etat = ".$Model['id_etat'];
		} else {
			$filtre .= "id_etat != 7";
		}
		if ( !empty($Model['recherche']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "( nom LIKE '%".$Model['recherche']."%' OR prenom LIKE '%".$Model['recherche']."%' OR licence LIKE '%".$Model['recherche']."%' OR note LIKE '%".$Model['recherche']."%' )";
		}
		if ( !empty($Model['id_role']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = ".$Model['id_role'].")";
		}
		if ( !empty($Model['actif']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "actif = ".$Model['actif'];
		}
		if ( !empty($Model['datecreation']) ) {
			if ( !empty($filtre) ) $filtre .= " AND ";
			$filtre .= "datecreation >= STR_TO_DATE('".$Model['datecreation']."','%d/%m/%Y')";
		}
		return $filtre;
	}
	
	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$membre = new Membre($_POST);
			if ( $membre->login == null )      $membre->login      = $membre->licence;
			if ( $membre->motdepasse == null ) $membre->motdepasse = uniqid();
			$membre->id_createur = Security::getConnectedUser()->id;
			if ( isset($_FILES['uploadfile']) && $_FILES['uploadfile']['error'] == 0 ) {
				$fichier = new Membre_Fichier($_POST);
				$fichier->getAttribut('uploadfile')->name = $membre->licence.substr($fichier->getAttribut('uploadfile')->name,strripos($fichier->getAttribut('uploadfile')->name,'.'));
				$membre->id_fichier = $fichier;
			}
			// Ajouter Liste des Rôles
			$membre->insert(true);
			// Gestion du passage d'une personne à l'essai à l'état de membre
//			if ( Personne::convertToMembre($membre) ) 
//				throw new GoPrevException('MSG-QUERYCONVERT');
//			else 
				throw new GoPrevException('MSG-QUERYINSERT');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Nouveau membre";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = new Membre();
		$Model['entity']->id_etat = 1;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$membre = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$membre->setAttributes($_POST);
			$fichier = $membre->id_fichier;
			if ( isset($_FILES['uploadfile']) && $_FILES['uploadfile']['error'] == 0 ) {
				if ( empty($fichier) ) $fichier = new Membre_Fichier($_POST);
				else $fichier->setAttributes($_POST);
				$fichier->getAttribut('uploadfile')->name = $membre->licence.substr($fichier->getAttribut('uploadfile')->name,strripos($fichier->getAttribut('uploadfile')->name,'.'));
			}
			else {
				if ( !empty($fichier) && empty($_POST['id_fichier']) ) {
					$fichier->aSupprimer();
				}
			}
			$membre->id_fichier = $fichier;
			$membre->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Modification de la fiche d'un adhérent.";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $membre;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
/*
	public function changePwdAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$membre = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			if ( !isset($_POST['motdepasse']) )                        throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'motdepasse') );
			if ( !isset($_POST['motdepasseConfirm']) )                 throw new Exception ( 'ERR-PARAM-NOPARAM', array('NOM' => 'passwordConfirm') );
			if ( $_POST['motdepasse'] != $_POST['motdepasseConfirm'] ) throw new Exception ( 'ERR-PASSWORD-NOTCONFIRMED' );
			$membre->updatePwd('motdepasse',$_POST['motdepasse']);
			throw new Exception('MSG-QUERYPWDUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Modification de la fiche d'un adhérent.";
		$Model['corps_page']    = 'lib/security/views/changePassword.php';
		$Model['entity']        = $membre;
		return array($Model['corps_page'],$Model,true);
	}
*/

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$membre = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$participants = Participant::selectList('id_membre='.$membre->id);
			foreach ( $participants as $participant ) {
				$participant->delete(true);
			}
			$membre->delete(true);
			throw new GoPrevException('MSG-QUERYDELETE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Suppression de la fiche d'un adhérent.";
		$Model['corps_page']    = static::$PATH_VIEW_DELETE;
		$Model['entity']        = $membre;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function archiveAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$membre = $params['entity'];
		// Validation d'un Formulaire
		$membre->archiver(); 
		$membre->update(true);
		throw new Exception('MSG-QUERYARCHIVE');
	}

	public function finRenouvellementAction($params=null)
	{
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de param�trage 
		$hostname = $tabVals['dbServer'];		// Nom du serveur h�bergeant la BD
		$database = $tabVals['dbName'];			// Nom de la base de donn�e
		$username = $tabVals['dbUser'];			// Nom de connexion de l'utilisateur
		$password = $tabVals['dbPassword'];		// Mot de passe de l'utilisater
		$date = date("Ymd_His");
		$fichier = fopen('data/traces/logBatchs.trc', 'a+');
		if ( Constantes::getParametre('date_renlicence')->valeur == date("d/m/Y") ) 
		{
			$chaine = date("Ymd_His")."\t -> ARCHIVAGE - SVG ARCHIVES : ARCH_${database}_${date}.sql\n";
			fputs($fichier, $chaine);
			echo $chaine."<br />";
			$retour = exec ("mysqldump --host=$hostname --user=$username --password=$password --no-create-info $database gari_membre gari_adresse gari_prevenir gari_cheque gari_brevet gari_role_membre > data/dumps/ARCH_${database}_${date}.sql");

			$lst = Membre::selectList("id_etat=2 AND id != 1");
			$chaine = date("Ymd_His")."\t -> ARCHIVAGE - ARCHIAVAGE membres non renouvelés: ".count($lst)."\n";
			fputs($fichier, $chaine);
			echo $chaine."<br />";
			foreach ( $lst as $membre ) 
			{
				if ( $membre->id != 1 ) $membre->archiver();
				$membre->update(true);
			}
			$chaine = date("Ymd_His")."\t -> ARCHIVAGE - MAILING au gestionnaire\n";
			fputs($fichier, $chaine);
			echo $chaine."<br />";
			Courriel::finRenouvellementMail(count($lst));
			$chaine = date("Ymd_His")."\t -> ARCHIVAGE - FIN\n";
			echo $chaine."<br />";
			fputs($fichier, $chaine);
		}
		else {
			$chaine = date("Ymd_His")."\t -> ARCHIVAGE - Date d'archivage pas encore atteinte (".Constantes::getParametre('date_renlicence')->valeur.")\n";
			echo $chaine."<br />";
			fputs($fichier, $chaine);
		}
		throw new Exception('MSG-QUERYARCHIVE');
	}

	public function changmtExerciceAction($params=null)
	{
		$tabVals = parse_ini_file('config/params.ini');	// Charge le fichier de param�trage 
		$hostname = $tabVals['dbServer'];		// Nom du serveur h�bergeant la BD
		$database = $tabVals['dbName'];			// Nom de la base de donn�e
		$username = $tabVals['dbUser'];			// Nom de connexion de l'utilisateur
		$password = $tabVals['dbPassword'];		// Mot de passe de l'utilisater
		$date = date("Ymd_His");
		
		$fichier = fopen('data/traces/logBatchs.trc', 'a+');
		$chaine = date("Ymd_His")."\t -> CHMTEXE - SVG ARCHIVES : ARCH_${database}_${date}.sql\n";
		fputs($fichier, $chaine);
		echo $chaine."<br />";
		$retour = exec ("mysqldump --host=$hostname --user=$username --password=$password --no-create-info $database gari_membre > data/dumps/CHMTEXE_${database}_${date}.sql");

		$lst = Membre::selectList("id_etat=1 AND id != 1");
		$chaine = date("Ymd_His")."\t -> CHMTEXE - Mise en attente des membres actifs: ".count($lst)."\n";
		fputs($fichier, $chaine);
		echo $chaine."<br />";
		foreach ( $lst as $membre ) 
		{
			if ( $membre->id != 1 ) $membre->id_etat = 2;
			$membre->update(true);
		}
		$chaine = date("Ymd_His")."\t -> CHMTEXE - FIN\n";
		fputs($fichier, $chaine);
		echo $chaine."<br />";
		throw new Exception('MSG-QUERYCHGMTEXE');
	}
	
	public function listFichierAction($params=null)
	{
	}
	
	public function addFichierAction($params=null)
	{
	}
	

	public function dropFichierAction($params=null)
	{
		if ( empty($_GET['id_fichier']) ) throw new Exception('ERR-NOID');
		$fichier = new Membre_Fichier( $_GET['id_fichier'] );
		$fichier->delete(true);
		throw new Exception('MSG-QUERYDELETE');
	}

	public function downloadAction($params=null)
	{
		if ( empty($_GET['id_fichier']) ) throw new Exception('ERR-NOID');
		$params['entity'] = new Membre_Fichier( $_GET['id_fichier'] );
		return parent::downloadAction($params);
	}
	
}