<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\Constantes;
use entities\Information;
use entities\Programme;
use entities\Phrase;

class InformationController extends EntityController
{
	protected static $ENTITY = "entities\Information";
	public static $SECURITY = array(
		'insert'       => array(5), 
		'update'       => array(5), 
		'delete'       => array(5), 
		);
	protected static $PATH_VIEW_INSERT    = 'views/information/insert.php';
	protected static $PATH_VIEW_UPDATE    = 'views/information/insert.php';

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			$information = new Information($_POST);
			$information->insert();
			throw new Exception('MSG-QUERYINSERT');
		}
		if ( empty($_GET['mois']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'mois' ));
		if ( empty($_GET['annee']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'annee' ));
		$Model['titre_page']    = "Nouvelle informaton mensuelle";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = new Information();
		$Model['entity']->mois_annee = "01/".$_GET['mois']."/".$_GET['annee'];
		$Model['entity']->position   = Information::selectMax('position',"mois_annee LIKE '".$_GET['annee']."-".$_GET['mois']."%'")+1;
		return array($Model['corps_page'],$Model,true);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'id' ));
		$information = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			$information->setAttributes($_POST);
			$information->update();
			throw new Exception('MSG-QUERYUPDATE');
		}
		$Model['titre_page']    = "Mise à jour informaton mensuelle";
		$Model['corps_page']    = static::$PATH_VIEW_UPDATE;
		$Model['entity']        = $information;
		$Model['position']      = $Model['entity']->position;
		return array($Model['corps_page'],$Model,true);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'id' ));
		$information = $params['entity'];
		$information->delete();
		throw new Exception('MSG-QUERYDELETE');
	}
	
}
