<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Courriel;
use lib\Exception;
use lib\GoPrevException;
use lib\security\Security;
use lib\Navigation;

use entities\Programme;
use entities\Programme_Fichier;

class FichierProgrammeController extends EntityController
{
	public static $SECURITY          = array(
		'insert'         => array(0,5), 
		'delete'         => array(0,5), 
		'dropFichier'    => array(0,5), 
		);
	
	protected static $ENTITY = "entities\Programme_Fichier";
	protected static $PATH_VIEW_INSERT       = 'views/programme_fichier/insert.php';

	public function dropFichierAction($params=null)
	{
		return $this->deleteAction($params);
	}
	
	/*
	 * Surcharge de la méthode getEntityObj 
	 * Teste le cas ou un identifiant programme est passé en paramètre  
	 * Dans ce cas retourne une objet Programme.
	 * Sinon appelle la méthode parent.
	 */
	protected function getEntityObj() 
	{
		$classEntity = static::$ENTITY;
		$idName = $classEntity::$COL_ID;
		$entityObj = null;
		if ( ( empty($_GET[$classEntity::$COL_ID]) && empty($_POST[$classEntity::$COL_ID]) ) 
			&& ( !empty($_GET[$classEntity::$COL_PROGRAMME]) || !empty($_POST[$classEntity::$COL_PROGRAMME]) ) ) 
		{
			$id = ( !empty($_GET[$classEntity::$COL_PROGRAMME]) ) ? $_GET[$classEntity::$COL_PROGRAMME] : $_POST[$classEntity::$COL_PROGRAMME] ;
			return new Programme($id);
		}
		else return parent::getEntityObj();
		
	}
	
}