<?php
namespace controllers;

use lib\EntityController;
use lib\DBConnexion;
use lib\Exception;

class FichierController extends EntityController
{
	public static $SECURITY = array(
		'add'           => true,
		'displayImg'    => true,
		'download'      => true,
		);
	
	protected static $ENTITY = "entities\Programme_Fichier";
	protected static $PATH_VIEW_INSERT     = 'views/fichier/add.php';
	protected static $PATH_VIEW_DISPLAYIMG = 'views/fichier/display.php';

	public function addAction($params=null)
	{
		$classe = static::$ENTITY;
		$Model['titre_page'] = "Ajouter un fichier";
		$Model['corps_page'] = static::$PATH_VIEW_INSERT;
		$Model['pos']        = ( isset($_GET['pos']) ) ? intval($_GET['pos']) : 1;
		$Model['entity']     = new $classe();
		return array(static::$PATH_VIEW_INSERT,$Model,true);
	}

	public function displayImgAction($params=null)
	{
		if ( empty( $_GET['entity'] ) ) throw new Exception("Erreur : nom de l'entité manquant.");
		if ( empty( $_GET['id'] ) ) throw new Exception('ERR-NOID');
		$classe = 'entities\\'.$_GET['entity'].'_Fichier';
		$Model['titre_page'] = "Affichage du fichier";
		$Model['corps_page'] = static::$PATH_VIEW_DISPLAYIMG;
		$Model['entity']     = new $classe( intval($_GET['id']) );
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function downloadAction($params=null)
	{
		if ( empty( $_GET['entity'] ) ) throw new Exception("Erreur : nom de l'entité manquant.");
		if ( empty( $_GET['id'] ) ) throw new Exception('ERR-NOID');
		$classe = 'entities\\'.$_GET['entity'].'_Fichier';
		$fichier = new $classe( intval($_GET['id']) );
		// Création des headers, pour indiquer au navigateur qu'il s'agit d'un fichier à télécharger
		header('Content-Transfer-Encoding: binary'); //Transfert en binaire (fichier)
		header('Content-Disposition: attachment; filename="'.$fichier->name.'"'); //Nom du fichier
		header('Content-Type: application/force-download');
		header('Content-Length: ' . $fichier->size); //Taille du fichier
		//Envoi du fichier dont le chemin est passé en paramètre
		readfile($fichier->url);
		exit;
	}
	
}