<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\Constantes;
use entities\Information;
use entities\Membre;
use entities\Programme;
use entities\Phrase;
use entities\Randonniere;

class EditionController extends EntityController
{
	protected static $PATH_VIEW_SELECT_TYPE_RANDO = 'views/programme/selectTypeRando.php';

	public static $SECURITY = array(
		'mensuel'            => array(2,3,4,5,8),
		'printInfo'          => array(2,3,4,5,8),
		'publieInfo'         => array(5),
		'printParticipants'  => array(2,5),
		'printAdherents'     => array(2,3,4,5),
		'extractAdherents'   => array(4,5,6),
		'extractCertifsAdherents' => array(7),
		'exportParticipants' => array(4,5,6),
		);
	
	public function mensuelAction($params=null)
	{
		if ( empty($_GET['mois']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'mois' ));
		if ( empty($_GET['annee']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'annee' ));
		$Model['titre_page']    = "Edition du programme mensuel";
		$Model['corps_page']    = "views/edition/mensuel.php";
		$Model['lstEntities']   = Information::selectList("mois_annee LIKE '".$_GET['annee']."-".$_GET['mois']."%'","position");
		$phrase = Phrase::selectList("mois_annee LIKE '".$_GET['annee']."-".$_GET['mois']."%'","mois_annee");
		if ( empty($phrase) ) {
			$phrase = new Phrase();
			$phrase->mois_annee = '01/'.$_GET['mois'].'/'.$_GET['annee'];
		}
		else $phrase = current($phrase);
		$Model['phrase']        = $phrase;
		$Model['mois']          = $_GET['mois'];
		$Model['annee']         = $_GET['annee'];
		return array("views/layout.php",$Model);
	}
	
	public function printInfoAction($params=null)
	{
		if ( ! empty($_GET['mois']) && ! empty($_GET['annee']) ) 
		{
			$Model['mois']          = $_GET['mois'];
			$Model['annee']         = $_GET['annee'];
			return array(static::$PATH_VIEW_SELECT_TYPE_RANDO,$Model,false);
		}
		if ( empty($_POST['mois']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'mois' ));
		if ( empty($_POST['annee']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'annee' ));
		$Model['titre_page']    = "Edition du programme mensuel";
		$Model['corps_page']    = "views/edition/printMensuel.php";
		$Model['lstInfos']      = Information::selectList("mois_annee LIKE '".$_POST['annee']."-".$_POST['mois']."%'","position");
		$Model['phrase']        = Phrase::selectList("mois_annee LIKE '".$_POST['annee']."-".$_POST['mois']."%'","mois_annee ASC");
		$Model['mois']          = $_POST['mois'];
		$Model['annee']         = $_POST['annee'];
		$Model['id_typerando']  = $_POST['id_typerando'];
		$datedeb = \DateTime::createFromFormat('Y-m-d',$_POST['annee']."-".$_POST['mois']."-01");
		$datefin = \DateTime::createFromFormat('Y-m-d',$_POST['annee']."-".$_POST['mois']."-01")->add( new \DateInterval('P1M') )->add( new \DateInterval('P'.(intval(Constantes::getParametre('date_jourmax')->valeur)-1).'D') );
		$filtre = "valide = 1 AND datedepart BETWEEN  '".$datedeb->format('Y-m-d')."' AND '".$datefin->format('Y-m-d')."'";
		$Model['lstProgs']      = Programme::filtreTypeRando(Programme::selectList($filtre,"datedepart ASC"),$Model['id_typerando']);
		$fichier = 'data/Programme_Mensuel_'.$_POST['mois'].'.pdf';
		
		ob_start();
		include($Model['corps_page']);
		$content = ob_get_clean();

		// convert to PDF
		require_once('lib/html2pdf/html2pdf.class.php');
		$html2pdf = new \HTML2PDF('P', 'A4', 'fr', true, 'UTF-8', 3);
		$html2pdf->pdf->SetDisplayMode('fullpage');
		$html2pdf->writeHTML($content);
		$html2pdf->Output($fichier,'D');
		exit;
	}
	
	public function publieInfoAction($params=null)
	{
		if ( empty($_GET['mois']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'mois' ));
		if ( empty($_GET['annee']) ) throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'annee' ));
		$Model['titre_page']    = "Edition du programme mensuel";
		$Model['corps_page']    = "views/edition/printMensuel.php";
		$Model['lstInfos']      = Information::selectList("mois_annee LIKE '".$_GET['annee']."-".$_GET['mois']."%'","position");
		$Model['phrase']        = Phrase::selectList("mois_annee LIKE '".$_GET['annee']."-".$_GET['mois']."%'","mois_annee ASC");
		$Model['mois']          = $_GET['mois'];
		$Model['annee']         = $_GET['annee'];
		$Model['id_typerando']  = 1;
		$datedeb = \DateTime::createFromFormat('Y-m-d',$_GET['annee']."-".$_GET['mois']."-01");
		$datefin = \DateTime::createFromFormat('Y-m-d',$_GET['annee']."-".$_GET['mois']."-01")->add( new \DateInterval('P1M') )->add( new \DateInterval('P'.(intval(Constantes::getParametre('date_jourmax')->valeur)-1).'D') );
		$filtre = "valide = 1 AND datedepart BETWEEN  '".$datedeb->format('Y-m-d')."' AND '".$datefin->format('Y-m-d')."'";
		$Model['lstProgs']      = Programme::filtreTypeRando(Programme::selectList($filtre,"datedepart ASC"),$Model['id_typerando']);
		$Model['edit'] = true;
		$fichier = 'data/Programme_Mensuel_'.$_GET['mois'].'.pdf';
		
		ob_start();
		include($Model['corps_page']);
		$content = ob_get_clean();
		
		// convert to PDF
		require_once('lib/html2pdf/html2pdf.class.php');
		$html2pdf = new \HTML2PDF('P', 'A4', 'fr', true, 'UTF-8', 3);
		$html2pdf->pdf->SetDisplayMode('fullpage');
		$html2pdf->writeHTML($content);
		$html2pdf->Output($fichier,'F');

		$fichierPublic = 'web/fichiers/docs/prog_suivant.pdf';
		if ( file_exists($fichierPublic) ) { unlink( $fichierPublic ); }
		copy( $fichier , $fichierPublic );
		throw new Exception('MSG-PUBLICATION-PDF');
	}
	
	public function printParticipantsAction($params=null)
	{
		if ( empty($_GET['idProgramme']) )  throw new Exception('ERR-FORM-OBLIGAT ',array( 'ATTRIBNAME' => 'idProgramme' ));
		$programme = new Programme(intval($_GET['idProgramme']));
		$Model['titre_page']    = "Edition de la liste des participants";
		$Model['corps_page']    = "views/edition/printParticipants.php";
		$Model['entity']        = $programme;
		
		ob_start();
		include($Model['corps_page']);
		$content = ob_get_clean();

		// convert to PDF
		require_once('lib/html2pdf/html2pdf.class.php');
		try
		{
			$html2pdf = new \HTML2PDF('P', 'A4', 'fr', true, 'UTF-8', 3);
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content);
			$html2pdf->Output('Participants_'.$programme->getAttribut('datedepart')->jour.'_'.$programme->getAttribut('datedepart')->mois.'_'.$programme->getAttribut('datedepart')->annee.'.pdf','D');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}
		exit;
	}
	
	public function printAdherentsAction($params=null)
	{
		$Model['titre_page']    = "Edition de la liste des Adhérents";
		$Model['corps_page']    = "views/edition/printAdherents.php";
		$Model['lstEntities'] = Membre::selectList("id_etat IN (1,2)",'nom,prenom');
		$nomFile = "extratAdherentsActifs.pdf";
		
		ob_start();
		include($Model['corps_page']);
		$content = ob_get_clean();

		// convert to PDF
		require_once('lib/html2pdf/html2pdf.class.php');
		try
		{
			$html2pdf = new \HTML2PDF('L', 'A4', 'fr', true, 'UTF-8', 3);
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content);
			$html2pdf->Output('extratAdherentsActifs.pdf','D');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}
		exit;
	}
	
	public function extractAdherentsAction($params=null)
	{
		$filtre = null;
		$nomFile = "extratAdherents.csv";
		if ( isset($_GET['actifs']) && $_GET['actifs'] == 1 ) {
			$filtre = "id_etat IN (1,2)";
			$nomFile = "extratAdherentsActifs.csv";
		}
		$Model['lstEntities'] = Membre::selectList($filtre,'nom,prenom');

		header("Content-disposition: attachment; filename=${nomFile}");
		header("Content-Type: application/force-download; charset=UTF-8");
		header("Content-Transfer-Encoding: application/octet-stream\n");
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0, public");
		header("Expires: 0");
		include "views/membre/extractCsv.php";
		exit;
	}
	
	public function extractCertifsAdherentsAction($params=null)
	{
		$filtre = null;
		$nomFile = "extratCertifsAdherents.csv";
		$filtre = "id_etat IN (1,2)";
		$Model['lstEntities'] = Membre::selectList($filtre,'nom,prenom');

		header("Content-disposition: attachment; filename=${nomFile}");
		header("Content-Type: application/force-download; charset=UTF-8");
		header("Content-Transfer-Encoding: application/octet-stream\n");
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0, public");
		header("Expires: 0");
		include "views/certificat/extractCsv.php";
		exit;
	}
	
	public function printPermanencesAction($params=null)
	{
		$datedeb = $_GET['datedeb'] ;
		$datefin = $_GET['datefin'] ;
		$filtre  = "type_event = 0";
		$filtre .= " AND date_event >= STR_TO_DATE('$datedeb','%d/%m/%Y') AND date_event <= STR_TO_DATE('$datefin','%d/%m/%Y')";
		$Model['titre_page']  = "Liste des permanences";
		$Model['corps_page']  = "views/edition/printReservations.php";
		$Model['lstEntities'] = Randonniere::selectList($filtre,'date_event,datestart_event');
		$Model['datedeb'] = $datedeb;
		$Model['datefin'] = $datefin;
		$this->getPdf( $Model , 'Permanences.pdf' );
		exit;
	}
	
	private function getPdf( $Model , $titrePdf ) 
	{
		ob_start();
		include($Model['corps_page']);
		$content = ob_get_clean();

		// convert to PDF
		require_once('lib/html2pdf/html2pdf.class.php');
		try
		{
			$html2pdf = new \HTML2PDF('P', 'A4', 'fr', true, 'UTF-8', 3);
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content);
			$html2pdf->Output($titrePdf,'D');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}
	}
	
	public function exportParticipantsAction($params=null)
	{
		$filtre = null;
		$nomFile = "exportParticipants.csv";
		$sqlstr = "
				SELECT
					MEM.licence AS PART_LICENCE,
					RES.licence AS PROG_RESP,
					PROG.datedepart AS PROG_DATEDEP,
					IF (PROG.valide = '3', 'OUI', 'NON') AS PROG_ANNULE,
					PROG.vehicule AS PROG_VEHICULE,
					PARC.nomParcour AS PARC_NOM,
					PARC.difficulte AS PARC_DIFF,
					PARC.longueur AS PARC_LONGUEUR,
					PARC.deniveleup AS PARC_LEVELUP,
					PARC.deniveledown AS PARC_LEVELDOWN,
					RAND.departement AS RAND_DEP,
					RAND.commune AS RAND_COMMUNE,
					RAND.lieu AS RAND_LIEU,
					TRAND.code AS TYPE_RAND
				FROM `gari_participant` as PART
				INNER JOIN gari_programme as PROG
					ON PART.id_programme = PROG.id
				INNER JOIN gari_randonnee as RAND
					ON RAND.id = PROG.id_randonnee
				INNER JOIN gari_typerando as TRAND
					ON RAND.id_typerando = TRAND.id
				LEFT JOIN gari_participant_parcour as PPAR
					ON PART.id_participant = PPAR.id_participant
				LEFT JOIN gari_parcour as PARC
					ON PPAR.id_parcour = PARC.id
				INNER JOIN gari_membre as MEM
					ON PART.id_membre = MEM.id
				INNER JOIN gari_membre as RES
					ON PROG.id_responsable = RES.id
				ORDER BY PROG_DATEDEP ASC, RAND_LIEU, PARC_NOM, PARC_DIFF, PART_LICENCE
				";
		global $dbcnx;
		$Model['lstEntities'] = $dbcnx->query($sqlstr);

		header("Content-disposition: attachment; filename=${nomFile}");
		header("Content-Type: application/force-download; charset=UTF-8");
		header("Content-Transfer-Encoding: application/octet-stream\n");
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0, public");
		header("Expires: 0");
		include "views/edition/exportQuery.php";
		exit;
	}
}
