<?php
namespace controllers;

use entities\Actualite;
use entities\Ephemeride;
use entities\Membre;
use lib\EntityController;
use lib\Exception;
use lib\GoPrevException;
use lib\Navigation;
use lib\Courriel;

class DefaultController extends EntityController
{
	public static $SECURITY = array(
		'accueil'         => true, 
		'mentionsLegales' => true, 
		'contact'         => true,
		'aide'            => array(4,5,6,7,8),
		);

	public function accueilAction()
	{
		$jour = date('d');
		$mois = date('m');
		$Model['titre_page']    = "Accueil";
		$Model['lstEntities']   = Actualite::selectList(null,'datecreation DESC');
		$Model['ephemeride']    = current(Ephemeride::selectList("jour=".intval($jour)." AND mois=".intval($mois)));
		$Model['annivs']        = Membre::selectList("DATE_FORMAT(datenaissance,'%d/%m') = '$jour/$mois' AND id_etat IN (1,2)");
		$Model['corps_page']    = "views/accueil.php";
		return array("views/layout.php",$Model);
	}

	public function mentionsLegalesAction()
	{
		$Model['titre_page']   = "Mentions légales";
		$Model['corps_page']    = "views/menu/mentionsLegales.php";
		return array("views/layout.php",$Model);
	}

	public function contactAction()
	{
		$Model['titre_page']   = "Nous contacter";
		$Model['corps_page']   = "views/contact/contact.php";
		return array("views/layout.php",$Model);
	}

	public function aideAction()
	{
		if ( isset($_POST['validForm']) && $_FILES['fileaide']['error'] == 0 ) 
		{
			$extension = substr( $_FILES['fileaide']['name'] , strripos( $_FILES['fileaide']['name'] , '.' )+1 );
			if ( strtolower($extension) != 'pdf' )
				throw new Exception( "Le fichier d'aide doit être au format <q>pdf</q>" );
			if ( !move_uploaded_file( $_FILES['fileaide']['tmp_name'] , 'web/fichiers/aide/page_aide.'.$extension ) ) 
				throw new Exception( 'ERR-FILE-UPLOADCOPY', array('FICHIERTEMP' => $_FILES['fileaide']['tmp_name'], 'FICHIER' => 'web/fichiers/aide/page_aide.'.$extension));
			throw new GoPrevException("Nouveau fichier d'aide Uploadé sur le serveur.");
		}
		$Model['titre_page']   = "Upload aide en ligne";
		$Model['corps_page']    = "views/administration/aide.php";
		return array("views/layout.php",$Model);
	}
	
	public function prevAction($params=null)
	{
		Navigation::callPrevUrl();
		return true;
	}

}