<?php
namespace controllers;

use lib\security\Security;
use lib\EntityController;
use lib\DBConnexion;
use lib\Exception;
use lib\GoPrevException;
use entities\Cheque;

class ChequeController extends EntityController
{
	public static $SECURITY = array(
		'add'           => array(6),
		'renouveler'    => array(6),
		);
	
	protected static $ENTITY = "entities\Cheque";
	protected static $PATH_VIEW_ADD    = 'views/cheque/add.php';
	protected static $PATH_VIEW_INSERT = 'views/cheque/insert.php';

	public function addAction($params=null)
	{
		$Model['titre_page']    = "Ajouter un paiement";
		$Model['corps_page']    = static::$PATH_VIEW_ADD;
		$Model['pos']           = ( isset($_GET['pos']) ) ? intval($_GET['pos']) : 1;
		$cheque = new Cheque();
		$cheque->nomCheque = ( isset($_GET['nomCheque']) ) ? $_GET['nomCheque'] : '' ;
		$Model['entityRel']        =  $cheque;
		return array(static::$PATH_VIEW_ADD,$Model,true);
	}

	public function renouvelerAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			if ( empty($_POST['id_membre']) ) throw new Exception('ERR-NOID');
			// Validation d'un Formulaire
			$cheque = new Cheque($_POST);
			$membre = $cheque->id_membre;
			$membre->activer();
			$membre->aModifier();
//			$membre->update(true);
			$cheque->id_membre = $membre;
			$cheque->insert(true);
			throw new GoPrevException('MSG-QUERYRENOUVELER');
		}
		// Affichage du formulaire
		if ( empty($_GET['id_membre']) ) throw new Exception('ERR-NOID');
		$cheque = new Cheque();
		$cheque->id_membre = intval($_GET['id_membre']);
		$Model['titre_page']    = "Renouvellement d'un adhérent.";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = $cheque;
		$Model['action']        = 'renouveler';
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
}
