<?php
namespace controllers;

use lib\EntityController;

use entities\TypeCertificat;
use entities\Certificat_Membre;
use entities\Membre;

class CertificatController extends EntityController
{
	public static $SECURITY = array(
		'list'           => array(5),
		'display'        => array(5), 
		'insert'         => array(5), 
		'update'         => array(7),
		'delete'         => array(7),
		'add'            => array(2,3,4,5,6,7),
		);
		
	protected static $ENTITY            = "entities\TypeCertificat";
	protected static $PATH_VIEW_LAYOUT  = 'views/layout.php';
	protected static $PATH_VIEW_ADD     = 'views/certificat/add.php';
	protected static $PATH_VIEW_INSERT  = 'views/certificat/insert.php';

	public function addAction($params=null)
	{
		$Model['titre_page']    = "Ajouter un certificat au Membre";
		$Model['corps_page']    = static::$PATH_VIEW_ADD;
		$Model['pos']           = ( isset($_GET['pos']) ) ? intval($_GET['pos']) : 1;
		$Model['entityRel']     = new Certificat_Membre();
		return array(static::$PATH_VIEW_ADD,$Model,true);
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			echo "<DIV>";
			if ( !empty($_POST['id_typecertificat']) ) {
				foreach ( $_POST['id_typecertificat'] as $idCertif ) {
					echo $idCertif."<BR>";
				}
			}
//			$membre = new Membre($_POST['id']);
//			echo $membre->displayCertificats();
			echo "</DIV>";
			exit;
		}
		$Model['titre_page'] = "Ajouter un certificat au Membre";
		$Model['corps_page'] = static::$PATH_VIEW_INSERT;
		$Model['entity']     = new Membre($_GET['id']);
		return array(static::$PATH_VIEW_INSERT,$Model,true);
	}
	
}