<?php
namespace controllers;

use lib\EntityController;
use lib\Exception;
use lib\GoPrevException;
use lib\CurrErrorException;
use lib\Constantes;
use lib\DBConnexion;
use lib\security\Security;
use entities\Randonniere;
use entities\Membre;
use entities\Permanencier;

class CalendrierController extends EntityController
{
	public static $SECURITY = array(
		'planning'        => array(2,3,4,5,6,7,8),
		'listPermanences' => array(2,3,4,5,6,7,8),
		'display'         => array(2,3,4,5,6,7,8),
		'delete'          => array(4,5,6,8),
		'insert'          => array(4,5,6,8),
		'update'          => array(4,5,6,8),
		'addPermanencier' => array(4,5,6,8),
		);

	protected static $ENTITY = "entities\Randonniere";
	protected static $PATH_VIEW_CALENDAR  = 'views/calendrier/display.php';
	protected static $PATH_VIEW_DISPLAY   = 'views/randonniere/display.php';
	protected static $PATH_VIEW_INSERT    = 'views/randonniere/insert.php';
	protected static $PATH_VIEW_UPDATE    = 'views/randonniere/insert.php';
	protected static $PATH_VIEW_CELLPERMA = 'views/randonniere/cellPermanencier.php';
	protected static $PATH_VIEW_LSTPERM   = 'views/randonniere/listePermanences.php';
	
	public function planningAction()
	{
		$dateTime   = \DateTime::createFromFormat( 'dmY' , ( isset($_GET['date']) ) ? $_GET['date'] : date('dmY') ) ;
		$dateTime->sub(new \DateInterval('P6D'));
		while ( $dateTime->format('w') != 1 ) $dateTime->add(new \DateInterval('P1D'));
		$Model['dateTime']   =  $dateTime->format('dmY');
		$Model['titre_page'] = "Planning Randonnière";
		$Model['corps_page'] = static::$PATH_VIEW_CALENDAR;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
	public function listPermanencesAction()
	{
		$dateTime   = \DateTime::createFromFormat( 'dmY' , '01'.date('mY') ) ;
		if ( !empty($_GET['date']) ) { 
			$Model['ISNEXT'] = true;
			$dateTime   = \DateTime::createFromFormat( 'dmY' , $_GET['date'] ) ;
		}
		$Model['datedeb'] = $dateTime->format('d/m/Y');
		$dateTime->add(new \DateInterval('P1M'));
		$Model['datefin']  = $dateTime->format('d/m/Y');
		$filtre  = "type_event = 0";
		$filtre .= " AND date_event >= STR_TO_DATE('".$Model['datedeb']."','%d/%m/%Y') AND date_event < STR_TO_DATE('".$Model['datefin']."','%d/%m/%Y')";
		$Model['titre_page']  = "Liste des permanences";
		$Model['corps_page']  = static::$PATH_VIEW_LSTPERM;
		$Model['lstEntities'] = Randonniere::selectList($filtre,'date_event,datestart_event');
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function displayAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$Model['titre_page'] = "Détail de l'évènement";
		$Model['corps_page'] = static::$PATH_VIEW_DISPLAY;
		$Model['entity']     = $params['entity'];
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function deleteAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$randonniere = $params['entity'];
		$randonniere->delete();
		$dateTime   = \DateTime::createFromFormat( 'dmY' , ( isset($_GET['date']) ) ? $_GET['date'] : date('dmY') ) ;
		$dateTime->sub(new \DateInterval('P6D'));
		while ( $dateTime->format('w') != 1 ) $dateTime->add(new \DateInterval('P1D'));
		$Model['dateTime']   =  $dateTime->format('dmY');
		$Model['titre_page'] = "Planning Randonnière";
		$Model['corps_page'] = static::$PATH_VIEW_CALENDAR;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function insertAction($params=null)
	{
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$randonniere = new Randonniere($_POST);
			$randonniere->id_createur = Security::getConnectedUser()->id;
			$randonniere->insert(true);
			$dateTime   = \DateTime::createFromFormat( 'dmY' , ( isset($_GET['date']) ) ? $_GET['date'] : date('dmY') ) ;
			$dateTime->sub(new \DateInterval('P6D'));
			while ( $dateTime->format('w') != 1 ) $dateTime->add(new \DateInterval('P1D'));
			$Model['dateTime']   =  $dateTime->format('dmY');
			$Model['titre_page'] = "Planning Randonnière";
			$Model['corps_page'] = static::$PATH_VIEW_CALENDAR;
			return array(static::$PATH_VIEW_LAYOUT,$Model);
		}
		// Affichage du formulaire
		$randonniere = new Randonniere();
		$randonniere->date_event = \Datetime::createFromFormat('dmY',$_GET['date'])->format('d/m/Y');
		if ( isset($_GET['type_event']) ) {
			$randonniere->type_event = $_GET['type_event'];
			switch ( $_GET['type_event'] )
			{
				case 0 : $randonniere->description_event = 'Permanence';break;
				case 1 : $randonniere->description_event = 'Autre évènement';break;
			}
		}
		$Model['titre_page']    = "Ajouter un évènement au calendrier";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = $randonniere;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}

	public function updateAction($params=null)
	{
		if ( empty($params['entity']) ) throw new Exception('ERR-NOID');
		$randonniere = $params['entity'];
		if ( isset($_POST['validForm']) ) {
			// Validation d'un Formulaire
			$randonniere->setAttributes($_POST);
			$randonniere->update(true);
			throw new GoPrevException('MSG-QUERYUPDATE');
		}
		// Affichage du formulaire
		$Model['titre_page']    = "Modifier un évènement du calendrier";
		$Model['corps_page']    = static::$PATH_VIEW_INSERT;
		$Model['entity']        = $randonniere;
		return array(static::$PATH_VIEW_LAYOUT,$Model);
	}
	
	public function addPermanencierAction($params=null)
	{
		if ( empty($_GET['valEntity']) ) throw new CurrErrorException('ERR-FORM-OBLIGAT',array( 'ATTRIBNAME' => 'Non du permanancier/Animateur' ));
		if ( !isset($_GET['type']) )     throw new CurrErrorException('ERR-FORM-OBLIGAT',array( 'ATTRIBNAME' => 'type' ));
		$nom  = DBConnexion::SQLEncode($_GET['valEntity']);
		$type = intval($_GET['type']);
		$participant = new Permanencier();
		$participant->type_permanencier = $type;
		$filtre = "'$nom' LIKE CONCAT(nom,' ',prenom)";
		if ( $type == 1 ) $filtre .= " AND id IN (SELECT id_membre FROM gari_role_membre WHERE id_role = 2)";
		$lst = Membre::selectList($filtre);
		if ( count($lst) == 1 ) $participant->id_membre = current($lst);
		else throw new CurrErrorException('MSG-PERSONNEINTROUVABLE');
		$Model['pos']           = intval($_GET['pos']);
		$Model['boutons']       = true;
		$Model['titre_page']    = "Ajouter un participant à la reconnaissance";
		$Model['corps_page']    = static::$PATH_VIEW_CELLPERMA;
		$Model['entityRel']     = $participant;
		return array($Model['corps_page'],$Model,true);
	}
	
}
